<?php
    $DB = new BigData();
    $stmt = $DB->getAllProducts();
    $num = $stmt->rowCount();
    $product_str='';
    $lineNumber = 0;
    $itemStock = '';
    if($num>0){
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
            extract($row);
            $lineNumber++;
            $imageURL = productImagePath($id,$img_path);
            if($isavailable == 0){
               $itemStock = '<span style="color:green">זמין</span>';     
            }else if($isavailable == 1){
               $itemStock = '<span style="color:red">לא זמין</span>'; 
            }
            $tableBody .='<tr>
                            <td>'.$lineNumber.'</td>
                            <td><img class="mk-img" src="..'.$imageURL.'" style="width:96px;"></td>
                            <td>'.$name.'</td>
                            <td>'.$catName.'</td>
                            <td>'.$code.'</td>
                            <td>'.$quantity.'</td>
                            <td>'.number_format($price,2,'.').'</td>
                            <td>'.$itemStock.'</td>
                            <td>
                            <button onclick="window.location.href=\'?pid=edit_pro&proID='.$id.'\'" type="button" class="btn btn-primary btn-block">עריכה</button>
                            </td>
                            </tr>';
        }//end while
    }//end if num>0

    function productImagePath($id,$default){
        $db = new BigData();
        $imagePath = '';
        $imageStmt = $db->getOneItemImage($id);
        $imageNum = $imageStmt->rowCount();
        if($imageNum > 0){
            while($imageRow = $imageStmt->fetch(PDO::FETCH_ASSOC)){
                extract($imageRow);
                $imagePath = $image_path;
            }
        }else{
            $imagePath = $default;
        }
        return $imagePath;
    }
?>

<div>
    <div class="col-sm-12 text-right" style="margin-bottom: 1%;">
        <button onclick="window.location.href='?pid=edit_pro'" type="button" class="btn btn-info">הוספת מוצר חדש</button>
        <button onclick="window.location.href='?pid=importProducts'" type="button" class="btn btn-warning">טעינת מוצרים</button>
        <!-- <button onclick="window.location.href='?pid=importImages'" type="button" class="btn btn-warning">הורדת קובץ קישורי תמונות</button> -->
    </div>
    <div class="col-sm-12">
    <table id="productsTable" class="table table-striped table-bordered" style="text-align:right ;">
        <thead>
            <tr>
                <th>#</th>
                <th>תמונה</th>
                <th>שם מוצר</th>
                <th>קטיגוריה</th>
                <th>ברקוד</th>
                <th>כמות בקרטון</th>
                <th>מחיר</th>
                <th>מלאי</th>
                <th>פעולות</th>
            </tr>
        </thead>
        <tbody>
            <?php echo $tableBody;?>
        </tbody>
    </table>
    </div>
</div>

<script>
    $(document).ready(function () {
        
            $('#productsTable').DataTable({
            "language": {
            "lengthMenu": " _MENU_ ",
            "zeroRecords": "לא נמצא מוצרים",
            "info": "מציג דף _PAGE_ מתוך _PAGES_",
            "infoEmpty": "אין מוצרים להציג",
            "infoFiltered": "(filtered from _MAX_ total records)",
            "paginate": {
            "first":      "ראשון",
            "last":       "אחרון",
            "next":       "הבא",
            "previous":   "קודם"
                        },
            "search": "חיפוש : ",
        }
        });

        reDraw();
        
    });
    //---------------------------------

    function reDraw(){
         var pageNo = Number(window.localStorage.getItem('dataTablePageNumber'));
         $('#productsTable').DataTable().page(pageNo).draw('page');
    }
 
    $('#productsTable').on( 'page.dt', function () {
        var info = $('#productsTable').DataTable().page.info();
        window.localStorage.setItem('dataTablePageNumber',info.page);
        console.log(window.localStorage.getItem('dataTablePageNumber'))
    } );
</script>
