<?php
$DB = new BigData();
date_default_timezone_set('Asia/Jerusalem');
$maamTax = 1;
$totalmaam = 1;
//-------------------------------------
    $settingStmt = $DB->getSettings();
    $settingNum = $settingStmt->rowCount();
    if($settingNum>0){
        while($settingRow = $settingStmt->fetch(PDO::FETCH_ASSOC)){
            extract($settingRow);
            $setting = json_decode($sett,false,512,JSON_UNESCAPED_UNICODE);
            //[{"calc":true},{"imageDisplay":true},{"imageSize":"128px"},{"isMaam":true}]
            if($setting[0]->calc == 0){
                echo '
                    <script>
                        $(document).ready(()=>{
                            $(".calcTR").css("display","none");
                        })
                    </script>
                ';
            }

            if($setting[1]->imageDisplay == 0){
                echo '
                    <script>
                        $(document).ready(()=>{
                            $(".productImage").css("display","none");
                        })
                    </script>
                ';
            }

            echo '
                    <script>
                        $(document).ready(()=>{
                            $(".productImage").css("width","'.$setting[2]->imageSize.'");
                        })
                    </script>
                '; 
            
            if($setting[3]->isMaam == 1){
                $maamTax = 0;
                $totalmaam = (($currentTax/100)+1);
            }

        }//end while
    }//end if
//-------------------------------------
if($_GET){
    $id = isset($_GET['orderID']) ? $_GET['orderID'] : '';
    $productArray = '';
    $customer_name = '';
    $p_placer = '';
    $customer_number='';
    $order_num='';
    $table_str = '';
    $quant=0;
    $cartonQ='';
    $barcodeNum='';
    $barcodeImg='';
    $or_status='';
    $status_msg='';
    $banNote='';
    $agentName='';
    $customer_city='';
    $orderTaxVal = 0;
    $x=0;
    $OrderTotal=0;
    if($id!=''){
        $or_stmt = $DB->getOrder($id);
        $or_num = $or_stmt->rowCount();

        if($or_num>0){
            while ($or_row = $or_stmt->fetch(PDO::FETCH_ASSOC)){
                extract($or_row);
                $productArray = json_decode($order_desc,false,512);
                //$productArray = $order_desc;
                $customer_name = $cust_n;
                $p_placer = $placer;
                $customer_number = $customer_num;
                $time = strtotime($created.'UTC');
                $dateInLocal = date("Y-m-d H:i", $time);
                $order_num= $order_number;
                $or_status = $order_status;
                $banNote = $ban_note;
                $agentName = $agent_name;
                $customer_city = $cust_city;
                $orderNote = $note;
                if($order_tax == 0){
                    $orderTaxVal = $currentTax;
                    $updateOrderTax = $DB->updateOrderTax($_GET['orderID'],$orderTaxVal);
                }else{
                    $orderTaxVal = $order_tax;
                }
            }//end while
        }//end if num>0
        foreach ($productArray as $product){
            $stmt = $DB->getOneProduct($product->product_id);
            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
                extract($row);
                $barcodeNum = $code;
                $barcodeImg = $barcode;
                $proPrice = $price;
                $imageURL = productImagePath($id,$img_path);
                if($product->type=='carton'){
                    $quant = $product->quantity * $quantity;
                    $cartonQ = $product->quantity;
                }elseif ($product->type=='unit'){
                    $quant = $product->quantity;
                    $cartonQ='';
                }
                $x++;
                if(($product->note) != ''){
                    $n = '<p class="productNote">'.$product->note.'</p>';
                }else{
                    $n = '';
                }
                $total = (($product->price)*$quant);
                if($product->sale == ''){
                    $lineSale = 0;
                }else{
                    $lineSale = ($product->sale)/100;
                }
                
                $proTotal = $total * $lineSale;
                $finalT = $total - $proTotal;
                $table_str.='<tr>
            <td>'.$x.'</td>
            <td>
            <img class="productImage" src="..'.$imageURL.'" width="72"  alt="product image">
            </td>
            <td>'.$barcodeNum.'</td>
            <td>'.$name.$n.'</td>
            <td>'.$cartonQ.'</td>
            <td>'.$quant.'</td>
            <td>'.($product->price).'&#8362;</td>
            <td>'.(isset(($product->sale)) ? ($product->sale) : 0).'%</td>
            <td>'.$finalT.'&#8362;</td>
        </tr>';

                //$total = $quant*$proPrice;
                $OrderTotal = $OrderTotal+$finalT;
                $orderTax = ((floatval($OrderTotal)*(($orderTaxVal/100)+1)) - $OrderTotal) * $maamTax;
            }//end while
        }//end foreach

        $table_str.='
        <tr class="calcTR">
        <td colspan="8" style="text-align:left">ס"הכ</td>
        <td>'.number_format($OrderTotal,2).'</td>
        </tr>
        <tr class="calcTR">
        <td colspan="8" style="text-align:left">מע"מ '.$orderTaxVal.'%</td>
        <td>'.$orderTax.'</td>
        </tr>
        <tr class="calcTR">
        <td colspan="8" style="text-align:left">ס"הכ כולל מע"מ</td>
        <td>'.number_format(((floatval($OrderTotal)*((($orderTaxVal/100)+1))) / $totalmaam),2).'</td>
        </tr>
        ';


        if($or_status=="2"){
            $status_msg = '<div class="alert alert-danger">
    סיבת השהייה :                        '.$banNote.'
                            </div>';
            $waitingBtn = '<button onclick="orderWaitingStatus()" data-toggle="tooltip" data-placement="bottom" title="ממתין" type="button" class="btn btn-warning"><i class="fas fa-clock"></i></button>';
        }elseif ($or_status=="0"){
            $editBtn = '<button onclick="window.location.href=\'?pid=order_edit&orderID='.$_GET['orderID'].'\'" data-toggle="tooltip" data-placement="bottom" title="עריכה" type="button" class="btn btn-warning"><i class="fas fa-pencil-alt"></i></button>';
        }
    }//end if id empty
}//end if get
//-------------------------------------
    if(isset($_GET['sysmsg'])){
        if($_GET['sysmsg'] === 'editOrderUpdateSuccess'){
            $currentTotalOrder = number_format($OrderTotal,2);
            $orderID = isset($_GET['orderID']) ? $_GET['orderID'] : '';
            $updateTotalOrder = $DB->updateTotalOrder($orderID,$currentTotalOrder);
        }
    }
//-------------------------------------
function productImagePath($id,$default){
    $db = new BigData();
    $imagePath = '';
    $imageStmt = $db->getOneItemImage($id);
    $imageNum = $imageStmt->rowCount();
    if($imageNum > 0){
        while($imageRow = $imageStmt->fetch(PDO::FETCH_ASSOC)){
            extract($imageRow);
            $imagePath = $image_path;
        }
    }else{
        $imagePath = $default;
    }
    return $imagePath;
}
?>

<div class="row">
    <div class="col-sm-6 text-right action-btns" style="margin-bottom: 5%;">
        <div class="btn-group" dir="ltr">
            <button onclick="PrintOrder();" type="button" class="btn btn-info"><i class="fas fa-print"></i></button>
            <button onclick="orderDoneStatus();" data-toggle="tooltip" data-placement="bottom" title="בוצע" type="button" class="btn btn-success"><i class="fas fa-check-circle"></i></button>
            <?php echo $waitingBtn;?>
            <button onclick="bannedOrder()" data-toggle="tooltip" data-placement="bottom" title="השהיה" type="button" class="btn btn-secondary"><i class="fas fa-ban"></i></button>
            <button onclick="GetTotal()" data-toggle="tooltip" data-placement="bottom" title="סכום" type="button" class="btn btn-dark"><i class="fas fa-comment-dollar"></i></button>
            <?php echo $editBtn; ?>
            <button onclick="delOrder();" data-toggle="tooltip" data-placement="bottom" title="מחיקה" type="button" class="btn btn-danger"><i class="far fa-trash-alt"></i></button>
        </div>
    </div>
    <!-- <div id="hashBtns" class="col-sm-6 text-left action-btns" style="margin-bottom: 5%; display:none;">
        <div class="btn-group" dir="ltr">
            <button onclick="send2Hash();" data-toggle="tooltip" data-placement="bottom" title="שידור להזמנת סוכן" type="button" class="btn btn-secondary"><img width="30" src="../ftp/icons/new/importicon.webp" alt=""></button>
        </div>
    </div> -->
    <?php echo $status_msg;?>
    <div class="col-sm-12" style="display: inline-flex !important; direction: rtl;">
        <div class="col-sm-6 text-right">
            <div>
                <p>מס' לקוח : <?php echo $customer_number;?></p>
                <p>עיר : <?php echo $customer_city;?></p>
                <p>שם מזמין : <?php echo $placer;?></p>
            </div>
        </div>
        <div class="col-sm-6 text-left">
            <div>
                <p>שם סוכן : <?php echo $agentName;?></p>
                <p>תאריך הזמנה : <?php echo $dateInLocal;?></p>
            </div>
            <div id="driver_name" style="display: none;">

            </div>
        </div>
    </div>
    <div class="col-sm-6 text-right" style="border: 2px solid #c54e0c;border-radius: 15px;padding: 1%;">
        <strong>הערת סוכן :</strong> <?php echo $orderNote;?>
    </div>
    <div class="col-sm-6"></div>
    <div class="col-sm-12 text-center">
        <h5 style="direction: rtl;">הזמנה מס' <?php echo $order_num;?></h5>
        <h3><?php echo $customer_name;?></h3>
    </div>
    <div class="msg"></div>
    <table id="orderTable" class="table table-condensed table-striped" style="direction: rtl;">
        <thead style="text-align: center; page-break-inside: auto;">
        <tr>
            <th>#</th>
            <th>תמונה</th>
            <th>קוד</th>
            <!--<th>ברקוד</th>-->
            <th>מוצר</th>
            <th>כמות קרטון</th>
            <th>כמות יח'</th>
            <th>מחיר יח</th>
            <th>הנחה %</th>
            <th>סה"כ</th>
        </tr>
        </thead>
        <tbody style="text-align: center;">
        <?php echo $table_str;?>
        </tbody>
    </table>
</div>

<div id="myModal" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content" style="
    direction: rtl;
    text-align: center;
    font-weight: 900;
">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <h4 class="modal-title">סכום הזמנה</h4>
      </div>
      <div class="modal-body">
        <p id="dataP" style="font-size: 20pt;">no Price Found</p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">סגור</button>
      </div>
    </div>

<script>
    $(document).ready(function(){
        $('[data-toggle="tooltip"]').tooltip();
    });
</script>

<script>
    function PrintOrder() {
        window.print();
        // var person = prompt("הכנס שם נהג");
        // if (person != null) {
        //     document.getElementById("driver_name").style.display="block";
        //     document.getElementById("driver_name").innerHTML = "שם נהג : "+person;
        //     window.print();
        // }
    }
</script>

<script>
    function delOrder() {
        Swal.fire({
            title: 'מחיקת הזמנה',
            text: 'אתה בטוח שברצונך למחוק הזמנה זו ?',
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            cancelButtonText: "לא",
            confirmButtonText: "כן, בטוח",
            dangerMode: true,
            }).then((result) => {
            if (result.isConfirmed) {
                deleteOrder();
            }
            });
    }
</script>

<script>
    function bannedOrder() {
        Swal.fire({
        title: "הכנס הערת השהיית הזמנה",
        input: "text",
        inputLabel: "הערת השהיית",
        showCancelButton: true,
        inputValidator: (value) => {
            if (value) {
            changeOrderStatus('2',value);
            }
        }
        });
    }
</script>

<script>
    function orderDoneStatus() {
        Swal.fire({
            title: 'שינוי סטטוס הזמנה',
            text: 'אתה בטוח שברצונך לשנות סטטוס לבוצע ?',
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            cancelButtonText: "לא",
            confirmButtonText: "כן, בטוח",
            dangerMode: true,
            }).then((result) => {
            if (result.isConfirmed) {
                changeOrderStatus('1','');
            }
            });
    }
</script>

<script>
    function orderWaitingStatus() {
        Swal.fire({
            title: 'שינוי סטטוס הזמנה',
            text: 'אתה בטוח שברצונך לשנות סטטוס לממתין ?',
            icon: "warning",
            showCancelButton: true,
            confirmButtonColor: "#3085d6",
            cancelButtonColor: "#d33",
            cancelButtonText: "לא",
            confirmButtonText: "כן, בטוח",
            dangerMode: true,
            }).then((result) => {
            if (result.isConfirmed) {
                changeOrderStatus('0','');
            }
            });
    }
</script>

<script>
    function deleteOrder() {
        var id = <?php echo $_GET['orderID'];?>;

        $.ajax({
            type:'POST',
            url:'../core/api/delete_order.php', // php page to get options
            data:{"id":id},// passing the value
            success:function(data){
                window.location='?pid=orders&msg='+data
            }
        });
    }
</script>

<script>
    function changeOrderStatus(status,msg) {
        var id = <?php echo $_GET['orderID'];?>;

        $.ajax({
            type:'POST',
            url:'../core/api/set_order_status.php', // php page to get options
            data:{"id":id,"status":status,"msg":msg},// passing the value
            success:function(data){
                window.location='?pid=order_show&orderID='+id+'&msg='+data
            }
        });
    }
</script>

<script>
    function GetTotal(){
        $total = <?php echo $OrderTotal;?>;
        $("#myModal").modal();
        $("#dataP").html($total+' &#8362;');
    }
</script>