<?php
       $DB = new BigData();
       $stmt = $DB->getAllProducts();
       $num = $stmt->rowCount();
       $product_str='';
       $lineNumber = 0;
       if($num>0){
           while ($row = $stmt->fetch(PDO::FETCH_ASSOC)){
               extract($row);
               $lineNumber++;
               $productStock = getStockByID($id);
               $tableBody .='                                                                                                                                                                               
               <tr>
                               <td>'.$lineNumber.'</td>
                               <td><input type="number" class="form-control" id="ids" name="ids[]" value="'.$id.'" readonly></td>
                               <td>'.$name.'</td>
                               <td><input type="text" class="form-control" id="code" name="code[]" value="'.$code.'" readonly></td>
                               <td>
                               <div class="mb-3 mt-3">
                               <input onfocus="selectAllTextInput(this)" type="number" class="form-control" id="quantity" name="quantity[]" value="'.$productStock.'">
                               </div>
                               </td>
                               </tr>';
           }//end while
       }//end if num>0

       function getStockByID($proID){
            $DB = new BigData();
            $stockStmt = $DB->getStockByProductID($proID);                          
            $stockNum = $stockStmt->rowCount();
            if($stockNum > 0){
                while($stockRow = $stockStmt->fetch(PDO::FETCH_ASSOC)){                      
                    extract($stockRow);
                    return $quantity;                                       
                }                                    
            }else{
                return 0;                                                                                                                                   
            }
       }
?>
<div class="row">
    <div class="col-12 text-center">
        <h3>הוספה / עריכת מלאי</h3>
    </div>
</div>
<div class="row">
    <div class="col-12 text-right">
    <button onclick="getQuants()" type="button" class="btn btn-success">עדכן</button>
    </div>
</div>
<div class="row">
    <div class="col-12">
    <table id="productsTable" class="table table-striped table-bordered" style="text-align:right ;">
        <thead>
            <tr>
                <th>#</th>
                <th>מספר מוצר</th>
                <th>שם מוצר</th>
                <th>ברקוד</th>
                <th>כמות</th>
            </tr>
        </thead>
        <tbody>
            <?php echo $tableBody;?>
        </tbody>
    </table>
    </div>
</div>


<script>
    $(document).ready(function () {

        $('#productsTable').DataTable({
            "language": {
            "lengthMenu": " _MENU_ ",
            "zeroRecords": "לא נמצא מוצרים",
            "info": "מציג דף _PAGE_ מתוך _PAGES_",
            "infoEmpty": "אין מוצרים להציג",
            "infoFiltered": "(filtered from _MAX_ total records)",
            "paginate": {
            "first":      "ראשון",
            "last":       "אחרון",
            "next":       "הבא",
            "previous":   "קודם"
                        },
            "search": "חיפוש : ",
        }
        });
    });
//------------------------------------------------------------------------
    function getQuants(){
        var table = $('#productsTable').DataTable();
        var quantArray = [];
        var idsArray = [];
        var codeArray = [];
        var allDataArray = [];

        var funcPromise = new Promise((myResolve)=>{
            table.rows().every( function ( rowIdx ) {
                var quant = $( this.node() ).first().find("input[name='quantity[]']").val();
                var ids = $( this.node() ).first().find("input[name='ids[]']").val();
                var code = $( this.node() ).first().find("input[name='code[]']").val();

                if(quant > 0){
                    quantArray.push(quant);
                    idsArray.push(ids);
                    codeArray.push(code);
                }else{
                    
                }
            });
            allDataArray.push(quantArray,idsArray,codeArray);
            myResolve(allDataArray);
        })

        funcPromise.then((value)=>{
            updateInventory(value);
        })
    }
//--------------------------------------------------------------------------
    function updateInventory(arr){
        $.ajax({
            url:'../core/api/invAPI/updateInv.php',
            type:'POST',
            data:{'arr':arr},
            success:function(updateRes){
                if(updateRes == 'success'){
                    window.location.reload();
                }else{
                    console.log(updateRes);
                }
                
            }
        })
    }
//----------------------------------------------------------------------------
    function selectAllTextInput(e){
        e.select();
    }
</script>