<div class="row">
    <div class="col-4 text-right">
        <button onclick="backBTN()" type="button" class="btn btn-outline-dark">חזרה</button>
        <button onclick="saveBid()" type="button" class="btn btn-outline-success">שמור</button>
    </div>
    <div class="col-4 text-center">
        <h3>הוספת / עריכת - הצעת מחיר</h3>
    </div>
    <div class="col-4 text-left">
        
    </div>
</div>
<!--/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\-->
<div class="col-sm-12 text-right" style="border-bottom: 2px solid #ced4da;">
    <div class="row">
        <div class="col">
            <div class="mb-3 mt-3">
                <label for="name" class="form-label">שם לקוח</label>
                <input type="text" class="form-control" id="customer_name" placeholder="הקלד שם לקוח">
            </div>
        </div>
        <div class="col">
            <div class="mb-3 mt-3">
                <label for="name" class="form-label">כתובת</label>
                <input type="text" class="form-control" id="customer_address" placeholder="הקלד כתובת לקוח">
            </div>
        </div>
        <div class="col">
            <div class="mb-3 mt-3">
                <label for="name" class="form-label">מספר נייד</label>
                <input type="text" class="form-control" id="customer_mobile" placeholder="הקלד נייד לקוח">
            </div>
        </div>
    </div>
</div>
<!--/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\-->
<div class="col-sm-12 text-right" style="border-bottom: 2px solid #ced4da;">
    <div class="row">
        <div class="col-12">
            <div class="mb-3 mt-3">
                <label for="productSelect" class="form-label">שם מוצר</label>
                <select onchange="getProductPrice()" class="js-example-basic-single" id="productSelect" style="width:100%"><option value="null">בחר מוצר</option></select>
            </div>
        </div>
        <div class="col">
            <div class="mb-3 mt-3">
                <label for="quantity" class="form-label">כמות</label>
                <input type="number" class="form-control" id="quantity" value="1">
            </div>
        </div>
        <div class="col">
            <div class="mb-3 mt-3">
                <label for="type" class="form-label">סוג</label>
                <select class="form-control" id="type">
                <!-- <option value="carton">קרטון</option> -->
                <option value="unit">יחידה</option>
                </select>
            </div>
        </div>
        <div class="col">
            <div class="mb-3 mt-3">
                <label for="proPrice" class="form-label">מחיר</label>
                <input type="text" class="form-control" id="proPrice" value="0">
            </div>
        </div>
        <div class="col-12">
            <div class="mb-3 mt-3">
                <div class="d-grid">
                    <button onclick="addRow()" type="button" class="btn btn-success btn-block">הוספת שורה</button>
                </div>
            </div>
        </div>
    </div>
</div>
<!--/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\/*\-->
<div class="col-sm-12 text-right">
  <table class="table table-striped mt-3">
    <thead>
      <tr>
        <th>#</th>
        <th>מוצר</th>
        <th>כמות</th>
        <th>סוג</th>
        <th>מחיר</th>
        <th>סכום</th>
      </tr>
    </thead>
    <tbody id="tableBody">
     
    </tbody>
  </table>
</div>

<!-- getProductsAllforID-->
<script>
    function getProductsAllforID(){
        $.ajax({
            url:'../core/api/getProductsForDocs.php',
            type:'POST',
            beforeSend:function(){

            },
            success:function(p){
                console.log()
                var productsList = JSON.parse(p);
                var productsOpt = '';
                for(var i=0; i<productsList['data'].length; i++){
                    productsOpt +='<option value="'+productsList['data'][i].id+'">'+productsList['data'][i].name+'</option>';
                }
                $('.js-example-basic-single').select2();
                $('#productSelect').append(productsOpt);
            }
        })
    }
//----------------------------------------------------------------
    $(document).ready(()=>{
        getProductsAllforID();
        $('.js-example-basic-single').select2();
        window.localStorage.removeItem('arr');
    })
//----------------------------------------------------------------
    function getProductPrice(){
        var proID = $('#productSelect').val();
        if(proID != 'null'){
           $.ajax({
                url:'../core/api/get_one_product.php',
                type:'POST',
                data:{'id':proID},
                success:function(r){
                    proJson = JSON.parse(r);
                    console.log(proJson[0].price);
                    $('#proPrice').val(proJson[0].price);
                }
            }); 
        }
    }
//----------------------------------------------------------------
    function addRow(){
        var arr = JSON.parse(window.localStorage.getItem('arr')) || [];
        //----------------------------------------------------
        var itemID = $('#productSelect').val();
        var quantity = $('#quantity').val();
        var type = $('#type').val();
        var proPrice = $('#proPrice').val();
        //----------------------------------------------------
            var isExist = false;
            arr.forEach((i)=>{
                if(i.id == itemID){
                    isExist = true;
                }
            })
        //----------------------------------------------------
        if(isExist == false){
            if(itemID != 'null'){
            $('.select2-container').css('border','unset');
                $.ajax({
                    url:'../core/api/bidAPI/save2array.php',
                    type:'POST',
                    data:{'itemID':itemID,'quantity':quantity,'type':type,'proPrice':proPrice},
                    itemArr:[],
                    itemsFinalArr:arr,
                    beforeSend:function(){

                    },
                    success:function(arrayRes){
                        var jsonArr = JSON.parse(arrayRes);
                        if(jsonArr.length > 0){
                            this.itemArr = jsonArr[0];
                        }
                    },
                    complete:function(){
                        arr.push(this.itemArr);
                        window.localStorage.setItem('arr',JSON.stringify(arr));
                        $('#quantity').val(1);
                        $('#productSelect').val('null');
                        $('#proPrice').val(0);
                        $('#select2-productSelect-container').html('בחר מוצר');
                        drawTable();
                    }
                })
            }else{
                    $('.select2-container').css('border','1px solid red');
                    $('.select2-container').css('border-radius','5px');
                    alert('יש לבחור מוצר !');
            }
        }else{
             alert('המוצר שנבחר נמצא ברשימה !');
        }
    }
//----------------------------------------------------------------
    function drawTable(){
        var arr = JSON.parse(window.localStorage.getItem('arr'));
        var row = '';
        var rowSum = 0;
        arr.forEach((item,indx)=>{
            row+='<tr>'+
                    '<td>'+indx+'</td>'+
                    '<td>'+item.name+'</br><span style="color:red">כמות בקרטון : '+item.quntInCarton+'</span></td>'+
                    '<td>'+item.quantity+'</td>'+
                    '<td>'+item.type+'</td>'+
                    '<td>'+item.price+'</td>'+
                    '<td>'+item.rowSum+'</td>'+
                '</tr>'
        })
        $('#tableBody').html(row);
    }
//----------------------------------------------------------------
    function backBTN(){
        window.location.href='?pid=bid';
    }
//----------------------------------------------------------------
    function saveBid(){
        var arr = JSON.parse(window.localStorage.getItem('arr')) || [];
        var customerName = $('#customer_name').val();
        var customerAddress = $('#customer_address').val();
        var customerMobile = $('#customer_mobile').val();
        //-------------------------------------------------
        if(arr.length > 0){
            if(customerName != ''){
                $.ajax({
                    url:'../core/api/bidAPI/savebid.php',
                    type:'POST',
                    data:{'arr':arr,'cn':customerName,'ca':customerAddress,'cm':customerMobile},
                    beforeSend:function(){

                    },
                    success:function(saveBidRes){
                        if(saveBidRes == 'success'){
                            window.location.href='?pid=bid';
                        }else{
                            alert(saveBidRes);
                        }
                    }
                })
            }else{
                alert('חסר שם לקוח');
            }
        }else{
            alert('חסר פריטים בהצעה!');
        }
        //-------------------------------------------------
    }
</script>