<?php
date_default_timezone_set('Asia/Jerusalem');
ob_start();
session_start();
include '../vendor/autoload.php';
include '../core/BigData.php';
include '../core/conn_cp_check.php';
include '../config/configurations.php';
$dataBase = new BigData();
$bnid_number =  $_SESSION['bnid'];
//--------------------------------------------
    $companyStmt = $dataBase->getCompany();
    $companyNum = $companyStmt->rowCount();
    $compname = '';
    $comphp = '';
    $compphone = '';
    $compmobile = '';
    $compfax = '';
    $compaddress = '';
    $complogo = '';
    if($companyNum > 0){
        while($companyRow = $companyStmt->fetch(PDO::FETCH_ASSOC)){
            extract($companyRow);
            $compname = $comp_name;
            $comphp = $comp_hp;
            $compphone = $comp_phone;
            $compmobile = $comp_mobile;
            $compfax = $comp_fax;
            $compaddress = $comp_address;
            $complogo = $comp_logo;
        }
    }
//--------------------------------------------
?>

<!DOCTYPE html>
<html lang="he" dir="rtl">
<head>
    <title>B-Agents System</title>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
        <!--Favicon -->
        <link rel="icon" href="../ftp/logo.webp?ver=1.4" type="image/x-icon"/>
    <!--Favicon -->
    <link rel="stylesheet" href="style/print.css?ver=2.0">
    <link rel="stylesheet" href="../style/bootstrap/css/bootstrap.min.css">
    <link href="style/fontawesome/css/all.css" rel="stylesheet">
    <link rel="stylesheet" href="style/style.css?ver=3.2">
    <script src="js/jquery-3.4.1.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
    <script src="style/bootstrap/js/bootstrap.js"></script>
    <link href="https://fonts.googleapis.com/css?family=Rubik&display=swap" rel="stylesheet">
    <link rel="stylesheet" type="text/css" href="style/data/datatables.min.css"/>
    <script type="text/javascript" src="style/data/datatables.min.js"></script>
    <script src="js/moment.js"></script>
    <script src="js/moment-timezone-with-data.js"></script>
    <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.10/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.10/js/select2.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        .lds-ellipsis {
            display: inline-block;
            position: relative;
            width: 80px;
            height: 80px;
        }
        .lds-ellipsis div {
            position: absolute;
            top: 33px;
            width: 13px;
            height: 13px;
            border-radius: 50%;
            background: #f4b400;
            animation-timing-function: cubic-bezier(0, 1, 1, 0);
        }
        .lds-ellipsis div:nth-child(1) {
            left: 8px;
            animation: lds-ellipsis1 0.6s infinite;
        }
        .lds-ellipsis div:nth-child(2) {
            left: 8px;
            animation: lds-ellipsis2 0.6s infinite;
        }
        .lds-ellipsis div:nth-child(3) {
            left: 32px;
            animation: lds-ellipsis2 0.6s infinite;
        }
        .lds-ellipsis div:nth-child(4) {
            left: 56px;
            animation: lds-ellipsis3 0.6s infinite;
        }
        @keyframes lds-ellipsis1 {
            0% {
                transform: scale(0);
            }
            100% {
                transform: scale(1);
            }
        }
        @keyframes lds-ellipsis3 {
            0% {
                transform: scale(1);
            }
            100% {
                transform: scale(0);
            }
        }
        @keyframes lds-ellipsis2 {
            0% {
                transform: translate(0, 0);
            }
            100% {
                transform: translate(24px, 0);
            }
        }
    </style>
    <link href="https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css" rel="stylesheet">
    <script src="https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js"></script>
    <script src="../assets/sweet/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="../assets/sweet/sweetalert2.min.css">
    <script src="../assets/js/html2canvas.js?ver=1.2"></script>
    <script src="js/jspdf.umd.min.js?ver=1.1"></script>
</head>
<body>

<header class="mk-header">
    <div class="mk-nav">
        <div class="mk-nav-div">
            <!-- <img class="mk-logo" src="../ftp/newIcons/logo.webp?ver=1.1"> -->
        </div>
        <div class="mk-nav-div mk-text-center">
            <div class="logoborder">
                <img class="mk-logo" src="../ftp/newIcons/logo.webp?ver=1.1">
            </div> 
        </div>
        <div class="mk-nav-div mk-text-left">
            <h6 onclick="window.location='?pid=logout'" class="mk-logout mk-center-horizon">יציאה <i class="fas fa-door-open"></i></h6>
        </div>
    </div>
</header>

<div class="mk-container">
    <div class="mk-container-left">
        <div class="mk-left-nav">
            <div class="mk-nav-url" onclick="window.location='?pid=main'">ראשי <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/home.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=orders'">הזמנות <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/orders.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=doneOrders'">ארכיון הזמנות <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/archive.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=returns'">החזרות <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/returns.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=bid'">הצעות מחיר <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/bids.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=customers'">לקוחות <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/customers.webp" alt=""></span></div>
            <!-- <div class="mk-nav-url" onclick="window.location='?pid=customers'">תיעוד <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/customers.webp" alt=""></span></div> -->
            <div class="mk-nav-url" onclick="window.location='?pid=agents'">סוכנים <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/agents.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=products'">מוצרים <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/items.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=diversity'">מוצרים בגיוון <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/diversity.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=inventory'">מלאי <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/inventory.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=category'">קטיגוריות <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/category.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=prices'">מחירונים <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/prices.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=sals'">מבצעים <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/sale.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=reports'">דו"חות <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/reports.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=settings'">הגדרות <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/setting.webp" alt=""></span></div>
            <div class="mk-nav-url" onclick="window.location='?pid=company'">הגדרות חברה <span class="img-sp"><img class="side-nav-img" src="../ftp/newIcons/cpanel/company.webp" alt=""></span></div>
        </div>
        <div class="mk-left-info">
            <?php require_once 'templates/left_info.php';?>
        </div>
    </div>
    <div class="mk-container-right">
        <div class="mk-main-container">
            <?php
            $pid = isset($_GET['pid']) ? $_GET['pid'] : 'main';
            switch ($pid){
                case 'main':
                    include 'templates/main.php';
                    break;
                case 'orders':
                    include 'templates/orders.php';
                    break;
                case 'doneOrders':
                    include 'templates/doneOrders.php';
                    break;
                case 'order_show':
                    include 'templates/order_show.php';
                    break;
                case 'MCOorders':
                    include 'templates/MCOorders.php';
                    break;
                case 'MCOdoneOrders':
                    include 'templates/MCOdoneOrders.php';
                    break;
                case 'MCOorder_show':
                    include 'templates/MCOorder_show.php';
                    break;
                case 'agents':
                    include 'templates/agents.php';
                    break;
                case 'products':
                    include 'templates/products.php';
                    break;
                case 'edit_pro':
                    include 'templates/product_edit.php';
                    break;
                case 'product_delete':
                    include '../core/api/delete_product.php';
                    break;
                case 'customers':
                    include 'templates/customers.php';
                    break;
                case 'newCustomer':
                    include 'templates/newCustomer.php';
                    break;
                case 'sals':
                    include 'templates/sals.php';
                    break;
                case 'reports':
                    include 'templates/reports.php';
                    break;
                case 'newSale':
                    include 'templates/newSale.php';
                    break;
                case 'returns':
                    include 'templates/rehearsals.php';
                    break;
                case 're_show':
                    include 'templates/rehear_show.php';
                    break;
                case 'order_edit':
                    include 'templates/order_edit.php';
                    break;
                case 'bid':
                    include 'templates/bids.php';
                    break;
                case 'addbid':
                    include 'templates/add_bid.php';
                    break;
                case 'showBid':
                    include 'templates/show_bid.php';
                    break;
                case 'invoices':
                    include 'templates/invoices.php';
                    break;
                case 'category':
                    include 'templates/category.php';
                    break;
                case 'prices':
                    include 'templates/prices.php';
                    break;
                case 'addprice':
                    include 'templates/addPrice.php';
                    break;
                case 'settings':
                    include 'templates/settings.php';
                    break;
                case 'logout':
                    include '../core/conn_logout.php';
                    break;
                case 'providers':
                    include 'templates/providers.php';
                    break;
                case 'inventory':
                    include 'templates/inventory/index.php';
                    break;
                case 'invAdd':
                    include 'templates/inventory/inv_add.php';
                    break;
                case 'diversity':
                    include 'templates/diversity.php';
                    break;
                case 'diversity_add':
                    include 'templates/diversity_add.php';
                    break;
                case 'diversity_update':
                    include 'templates/diversity_update.php';
                    break;
                case 'company':
                    include 'templates/company.php';
                    break;
                case 'importImages':
                    include 'templates/import/import_images.php';
                    break;
                case 'importProducts':
                    include 'templates/import/import_products.php';
                    break;
            }//end switch
            ?>
        </div>
    </div>
</div>
<?php include 'templates/scripts.php';?>
</body>
</html>