<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");
date_default_timezone_set('Asia/Jerusalem');

if($_SERVER['REQUEST_METHOD'] === 'POST'){

    // get posted data
    $data = json_decode(file_get_contents("php://input"));

session_start();
$orderID = isset($data->orderID) ? $data->orderID : 'null';
include '../BigData.php';
$DB = new BigData();


    //**------------ GET All Products ---------->

    $stmt = $DB->getOneMCOOrder($orderID);
    $num = $stmt->rowCount();
    $number = 0;
    $productArray = '';
    $barcodeNum ='';
    $barcodeImg ='';
    $proPrice = '';
    $quant = 0;
    $cartonQ = '';
    $x=0;
    $total=0;
    $lineSale=0;
    $proTotal=0;
    $finalT=0;
    $OrderTotal =0;
    $orderTax=0;

    if($num>0){
        $order_arr=array();
        $pro_arr = array();
        while ($row=$stmt->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            $number++;

            $productArray = json_decode($order_desc,false,512);

            foreach ($productArray as $product){
                $oneProstmt = $DB->getOneProduct($product->product_id);
                while ($oneProRow = $oneProstmt->fetch(PDO::FETCH_ASSOC)){
                    extract($oneProRow);
                    $barcodeNum = $code;
                    $barcodeImg = $barcode;
                    $proPrice = $price;
                    if($product->type=='carton'){
                        $quant = $product->quantity * $quantity;
                        $cartonQ = $product->quantity;
                    }elseif ($product->type=='unit'){
                        $quant = $product->quantity;
                        $cartonQ='';
                    }
                    $x++;
                    if(($product->note) != ''){
                        $n = $product->note;
                    }else{
                        $n = '';
                    }
                    $total = (($product->price)*$quant);
                    $lineSale = ($product->sale)/100;
                    $proTotal = $total * $lineSale;
                    $finalT = $total - $proTotal;

                    //$total = $quant*$proPrice;
                    $OrderTotal = $OrderTotal+$finalT;
                    $orderTax = ((floatval($OrderTotal)*(1.17)) - $OrderTotal) * $maamTax;

                    $product_item = array(
                        "num" => $x,
                        "name" => $name,
                        "quantity" => $quant,
                        "price" => $product->price,
                        "note" => $product->note
                    );

                    array_push($pro_arr,$product_item);
                }//end while
            }//end foreach

            $order_item=array(
                "msg"=>"success",
                "id" => $id,
                "number"=> $number,
                "order_number" => $order_number,
                "order_products" => $pro_arr,
                "created" => $created,
                "order_status" => $order_status
            );

            array_push($order_arr, $order_item);
        }//End while
        // set response code - 200 OK
        http_response_code(200);

        // show products data in json format
        $jsonencode = json_encode($order_arr);
        echo $jsonencode;
    }else{
        echo json_encode(array(array("msg"=>"noOrders")));
    }

    //**------------ GET All Products ---------->

}

?>