<?php

class HashApi
{

    private $station;
    private $netPassport;
    private $company;
    private $token;

    public function set_station($s){
        $this->station = $s;
    }

    public function get_station(){
        return $this->station;
    }

    public function set_net_passport($n){
        $this->netPassport = $n;
    }

    public function get_net_passport(){
        return $this->netPassport;
    }

    public function set_company($c){
        $this->company = $c;
    }

    public function get_company(){
        return $this->company;
    }

    public function set_token($t){
        $this->token = $t;
    }

    public function get_token(){
        return $this->token;
    }

    public function signature($plugin){
        $token = $this->get_token();
        $signature = md5($plugin.$token);
        return $signature;
    }

    public function create_item($pluginData){

        $station = $this->get_station();
        $netPassport = $this->get_net_passport();
        $company = $this->get_company();
        $signature = $this->signature($pluginData);

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://ws.wizground.com/api',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "station": "'.$station.'",
            "plugin": "itemin",
            "message": {
                "netPassportID": "'.$netPassport.'",
                "pluginData": '.$pluginData.'
            },
            "signature": "'.$signature.'",
            "company": "'.$company.'"
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }//end create_item

    public function get_item($pd){

        $pluginData = $pd;

        $station = $this->get_station();
        $netPassport = $this->get_net_passport();
        $company = $this->get_company();
        $signature = $this->signature($pluginData);

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://ws.wizground.com/api',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "station": "'.$station.'",
            "plugin": "reports",
            "message": {
                "netPassportID": "'.$netPassport.'",
                "pluginData": '.$pluginData.'
            },
            "signature": "'.$signature.'",
            "company": "'.$company.'"
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }//end get_item

    public function get_all_items($pd){

        $pluginData = $pd;

        $station = $this->get_station();
        $netPassport = $this->get_net_passport();
        $company = $this->get_company();
        $signature = $this->signature($pluginData);

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://ws.wizground.com/api',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "station": "'.$station.'",
            "plugin": "reports",
            "message": {
                "netPassportID": "'.$netPassport.'",
                "pluginData": '.$pluginData.'
            },
            "signature": "'.$signature.'",
            "company": "'.$company.'"
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }//end get_item

    public function get_customer_info($pd){

        $pluginData = $pd;

        $station = $this->get_station();
        $netPassport = $this->get_net_passport();
        $company = $this->get_company();
        $signature = $this->signature($pluginData);

        $curl = curl_init();

        curl_setopt_array($curl, array(
        CURLOPT_URL => 'https://ws.wizground.com/api',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS =>'{
            "station": "'.$station.'",
            "plugin": "reports",
            "message": {
                "netPassportID": "'.$netPassport.'",
                "pluginData": '.$pluginData.'
            },
            "signature": "'.$signature.'",
            "company": "'.$company.'"
        }',
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }//end get_item 
    
}//end class

?>