<?php
include '../../BigData.php';
$DB = new BigData();

function productImagePath($id,$default){
    $db = new BigData();
    $imagePath = '';
    $imageStmt = $db->getOneItemImage($id);
    $imageNum = $imageStmt->rowCount();
    if($imageNum > 0){
        while($imageRow = $imageStmt->fetch(PDO::FETCH_ASSOC)){
            extract($imageRow);
            $imagePath = $image_path;
        }
    }else{
        $imagePath = '/ftp/newIcons/logo.webp';
    }
    return $imagePath;
}

//**------------ GET All Products ---------->

if($_SERVER['REQUEST_METHOD'] === 'POST'){

    $id = isset($_POST['itemID']) ? $_POST['itemID'] : '';
    $item_quantity = isset($_POST['quantity']) ? $_POST['quantity'] : '';
    $item_type = isset($_POST['type']) ? $_POST['type'] : '';
    $item_proPrice = isset($_POST['proPrice']) ? $_POST['proPrice'] : '';

    $stmt = $DB->getOneProduct($id);
    $num = $stmt->rowCount();

    if($num>0){
        $products_arr=array();
        while ($row=$stmt->fetch(PDO::FETCH_ASSOC)){
            extract($row);

            if($item_type == 'carton'){
                $itemType = 'קרטון';
                $rowSum = $quantity*$item_quantity*$item_proPrice;
            }else if($item_type == 'unit'){
                $itemType = 'יחידה';
                $rowSum = $item_proPrice*$item_quantity;
            }


            $imageURL = productImagePath($row['id'],$img_path);


            $product_item=array(
                "id" => $id,
                "name" => $name,
                "code" => $code,
                "img" => $imageURL,
                "quantity" => $item_quantity,
                "quntInCarton"=>$quantity,
                "price" => number_format($item_proPrice,2,'.',''),
                "available" => $isavailable,
                "type" => $itemType,
                "rowSum" =>number_format($rowSum,2,'.','')
            );

            array_push($products_arr, $product_item);
        }//End while
        // set response code - 200 OK
        http_response_code(200);

        // show products data in json format
        echo json_encode($products_arr,JSON_UNESCAPED_UNICODE);
    }else{
        echo json_encode(array());
    }

//**------------ GET All Products ---------->

}//end post


?>