<?php
/**
 * Created by PhpStorm.
 * User: muhammedkartawi
 * Date: 15/03/2019
 * Time: 15:56
 * Update : 20/12/2022
 */

class BigData
{

    public function getMerkazInfo(){

        include'conn_db.php';

        $query = "SELECT * FROM `merkazem`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllProducts(){

        include'conn_db.php';

        $query = "SELECT products.*, category.name as catName FROM `products` INNER JOIN category ON products.cat_id=category.id ORDER BY products.created DESC ";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End
    public function getAllProductsLimited(){

        include'conn_db.php';

        $query = "SELECT products.*, category.name as catName FROM `products` INNER JOIN category ON products.cat_id=category.id ORDER BY products.cat_id, products.name ASC ";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllProductsByCatID($id){

        include'conn_db.php';

        $query = "SELECT products.*, category.name as catName FROM `products` INNER JOIN category ON products.cat_id=category.id WHERE products.cat_id = '{$id}' ORDER BY products.cat_id, products.name ASC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getLastProduct(){

        include'conn_db.php';

        $query = "SELECT products.id as LasetItemID FROM `products` ORDER BY `id` DESC LIMIT 0,1";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneProduct($id){

        include'conn_db.php';

        $query = "SELECT * FROM `products` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneProductByBarcode($barcode){

        include'conn_db.php';

        $query = "SELECT products.*, category.name as catName FROM `products` INNER JOIN category ON products.cat_id=category.id WHERE (products.code='{$barcode}')";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getLastCustomers(){

        include'conn_db.php';

        $query = "SELECT * FROM `customers` ORDER BY `id` DESC LIMIT 1";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllCustomers(){

        include'conn_db.php';

        $query = "SELECT * FROM `customers`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

        public function getAllCustomersforDiversity(){

        include'conn_db.php';

        $query = "SELECT name as CustomerName, id as CustomerID FROM `customers` GROUP BY name";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllArabCustomers(){

        include'conn_db.php';

        $query = "SELECT * FROM `customers` WHERE `ara_name`!= ''";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneCustomer($id){

        include'conn_db.php';

        $query = "SELECT * FROM `customers` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllCustomerByCusNum($id){

        include'conn_db.php';

        $query = "SELECT * FROM `customers` WHERE (`cust_num`='{$id}')";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllOrders(){

        include'conn_db.php';

        $query = "SELECT orders.*, customers.name as cust_n, customers.city as cust_city, users.u_name as agent_name FROM `orders` INNER JOIN customers ON orders.customer_id=customers.id INNER JOIN users ON orders.agent_id=users.id WHERE (orders.deleted=0 AND (orders.order_status=0 OR orders.order_status=2)) ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllMCOrders(){

        include'conn_db.php';

        $query = "SELECT mco_order.*, customers.name as cust_n, customers.city as cust_city, users.u_name as agent_name FROM `mco_order` INNER JOIN customers ON mco_order.customer_id=customers.id INNER JOIN users ON mco_order.agent_id=users.id WHERE (mco_order.deleted=0) ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllMCOrdersForOneCustomerNumber($custID){

        include'conn_db.php';

        $query = "SELECT * FROM `mco_order` WHERE `customer_id`='{$custID}' ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneMCOOrder($id){

        include'conn_db.php';

        $query = "SELECT * FROM `mco_order` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllDoneOrders(){

        include'conn_db.php';

        $query = "SELECT orders.*, customers.name as cust_n, customers.city as cust_city, users.u_name as agent_name FROM `orders` INNER JOIN customers ON orders.customer_id=customers.id INNER JOIN users ON orders.agent_id=users.id WHERE (orders.deleted=0 AND orders.order_status=1) ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllOrdersWithDeleted(){

        include'conn_db.php';

        $query = "SELECT orders.*, customers.name as cust_n, users.u_name as agent_name FROM `orders` INNER JOIN customers ON orders.customer_id=customers.id INNER JOIN users ON orders.agent_id=users.id ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOrdersByAgentID($id){

        include'conn_db.php';

        $query = "SELECT orders.*, customers.name as cust_n, customers.ara_name as ara_cust_n FROM `orders` INNER JOIN customers ON orders.customer_id=customers.id WHERE `agent_id` = '{$id}' AND orders.deleted=0 ORDER BY `created` DESC ";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOrder($id){

        include'conn_db.php';

        $query = "SELECT orders.*, customers.name as cust_n, customers.city as cust_city, users.u_name as agent_name FROM `orders` INNER JOIN customers ON orders.customer_id=customers.id INNER JOIN users ON orders.agent_id=users.id WHERE orders.id = '{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllAgents(){
        include'conn_db.php';
        $query = "SELECT * FROM `users`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function getOneAgent($id){
        include'conn_db.php';
        $query = "SELECT * FROM `users` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }

    public function getAllRehearsals(){

        include'conn_db.php';

        $query = "SELECT rehearsals.*, customers.name as cust_n, customers.city as cust_city, users.u_name as agent_name FROM `rehearsals` INNER JOIN customers ON rehearsals.customer_id=customers.id INNER JOIN users ON rehearsals.agent_id=users.id WHERE (rehearsals.deleted=0) ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllRehearsalsWithDeleted(){

        include'conn_db.php';

        $query = "SELECT rehearsals.*, customers.name as cust_n, users.u_name as agent_name FROM `rehearsals` INNER JOIN customers ON rehearsals.customer_id=customers.id INNER JOIN users ON rehearsals.agent_id=users.id ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getReahearsalsByAgentID($id){

        include'conn_db.php';

        $query = "SELECT rehearsals.*, customers.name as cust_n FROM `rehearsals` INNER JOIN customers ON rehearsals.customer_id=customers.id WHERE `agent_id` = '{$id}' AND rehearsals.deleted=0 ORDER BY `created` DESC ";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneReahearsals($id){

        include'conn_db.php';

        $query = "SELECT rehearsals.*, customers.name as cust_n, customers.cust_num as customer_num, customers.city as cust_city, users.u_name as agent_name FROM `rehearsals` INNER JOIN customers ON rehearsals.customer_id=customers.id INNER JOIN users ON rehearsals.agent_id=users.id WHERE rehearsals.id = '{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllSales(){

        include'conn_db.php';

        $query = "SELECT * FROM `sales` ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllSalesBySaleID($id){

        include'conn_db.php';

        $query = "SELECT * FROM `sals` WHERE `sale_id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

        public function getAllSalesByItemID($id){

        include'conn_db.php';

        $query = "SELECT sals.*, sales_type.name AS saleTypeName FROM `sals` INNER JOIN `sales_type` ON sales_type.id = sals.sale_id WHERE sals.product_id='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

        public function getAllSalesTypes(){

        include'conn_db.php';

        $query = "SELECT * FROM `sales_type`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllBids(){

        include'conn_db.php';

        $query = "SELECT * FROM `bid` ORDER BY `id` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneBid($id){

        include'conn_db.php';

        $query = "SELECT * FROM `bid` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getCustomerHistoryByID($id){

        include'conn_db.php';

        $query = "SELECT * FROM `history` WHERE `cust_id`='{$id}' ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllCategories(){

        include'conn_db.php';

        $query = "SELECT * FROM `category` ORDER BY `position` ASC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneCategory($id){

        include'conn_db.php';

        $query = "SELECT * FROM `category` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getProductByCategory($id){

        include'conn_db.php';

        $query = "SELECT * FROM `products` WHERE `cat_id`='{$id}' ORDER BY `name` ASC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function searchCustomers($d){

        include'conn_db.php';

        $query = "SELECT * FROM `customers` WHERE (`name` LIKE '%{$d}%' OR `ara_name` LIKE '%{$d}%' OR `hp` LIKE '%{$d}%' OR `cust_num` LIKE '%{$d}%' OR `city` LIKE '%{$d}%')";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllPrices(){

        include'conn_db.php';

        $query = "SELECT prices.*, customers.name AS CustomerName, products.name AS ProductName FROM `prices` INNER JOIN customers ON customers.id=prices.customer_id INNER JOIN products ON products.id=prices.product_id";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOnePrices($id){

        include'conn_db.php';

        $query = "SELECT * FROM `prices` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getPricesByCustomerID($CustomerID){ 

        include'conn_db.php';

        $query = "SELECT * FROM `prices` WHERE (`customer_id`='{$CustomerID}')";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOnePricesByProduct($productID){ 

        include'conn_db.php';

        $query = "SELECT * FROM `prices` WHERE (`product_id`='{$productID}')";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getMerIDByCatalogID($Catid){

        include'conn_db.php';

        $query = "SELECT * FROM `merkazem` WHERE `catalog_id`='{$Catid}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getSettings(){

        include'conn_db.php';

        $query = "SELECT * FROM `settings`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllProviders(){

        include'conn_db.php';

        $query = "SELECT * FROM `providers`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getOneProviders($id){

        include'conn_db.php';

        $query = "SELECT * FROM `providers` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getHashrep(){

        include'conn_db.php';

        $query = "SELECT * FROM `hashrep`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getCustomerInfoMCO($umail,$upass){

        include'conn_db.php';

        $query = "SELECT * FROM `customers` WHERE (`usrName` = '{$umail}' AND `usrPass` = '{$upass}')";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function searchProducts($d){

        include'conn_db.php';

        $query = "SELECT * FROM `products` WHERE (`name` LIKE '%{$d}%' OR `code` LIKE '%{$d}%') LIMIT 0,20";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllStock(){

        include'conn_db.php';

        $query = "SELECT * FROM `stocks`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getStockByProductID($productID){

        include'conn_db.php';

        $query = "SELECT * FROM `stocks` WHERE `product_id`='{$productID}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getItemImages($productID){

        include'conn_db.php';

        $query = "SELECT * FROM `images` WHERE `item_id`='{$productID}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getOneItemImage($productID){

        include'conn_db.php';

        $query = "SELECT * FROM `images` WHERE `item_id`='{$productID}' ORDER BY `id` ASC Limit 0,1";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getTMPorder($tmp){

        include'conn_db.php';

        $query = "SELECT * FROM `tmp_orders` WHERE `tmp`='{$tmp}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getTMPorderByAgentID($agentID){

        include'conn_db.php';

        $query = "SELECT * FROM `tmp_orders` WHERE `agentID`='{$agentID}' ORDER BY `created` DESC";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End 

    public function getdiversityByCustomerID($id){

        include'conn_db.php';

        $query = "SELECT * FROM `diversity` WHERE `customer_id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

        public function getdiversityByCustomerName($name){

        include'conn_db.php';

        $query = "SELECT * FROM `diversity` WHERE `customer_name`='{$name}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

       public function getdiversityGroupedByCustomerID(){

        include'conn_db.php';

        $query = "SELECT customer_id as customerID, customer_name as custName FROM diversity GROUP BY customer_id";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllDevices(){

        include'conn_db.php';

        $query = "SELECT * FROM `devices`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOneDevice($id){

        include'conn_db.php';

        $query = "SELECT * FROM `devices` WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getCompany(){

        include'conn_db.php';

        $query = "SELECT * FROM `company`";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    //---------------------------------------------------------------

    public function insertOrder($order_num,$cust_num,$cust_id,$order_desc,$placer,$note,$agent_id,$tax,$total){

        include'conn_db.php';

        $query = "INSERT INTO `orders`(`order_number`,`customer_num`,`customer_id`,`order_desc`,`placer`,`note`,`agent_id`,`order_tax`,`order_total`) VALUES ('{$order_num}','{$cust_num}','{$cust_id}','{$order_desc}','{$placer}','{$note}','{$agent_id}','{$tax}','{$total}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    public function insertMCOrder($order_num,$cust_num,$cust_id,$order_desc,$placer,$note,$agent_id){

        include'conn_db.php';

        $query = "INSERT INTO `mco_order`(`order_number`,`customer_num`,`customer_id`,`order_desc`,`placer`,`note`,`agent_id`) VALUES ('{$order_num}','{$cust_num}','{$cust_id}','{$order_desc}','{$placer}','{$note}','{$agent_id}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertRehearsals($re_num,$cust_id,$re_desc,$placer,$agent_id){

        include'conn_db.php';

        $query = "INSERT INTO `rehearsals`(`re_num`, `customer_id`, `re_desc`,`placer`, `agent_id`) VALUES ('{$re_num}','{$cust_id}','{$re_desc}','{$placer}','{$agent_id}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End


    public function insertCustomer($cust_name,$ara_name,$cust_hp,$cust_num,$cust_city,$phone,$mobile){

        include'conn_db.php';

        $query = "INSERT INTO `customers`(`name`, `ara_name`, `hp`, `cust_num`, `city`,`phone`,`mobile`) VALUES ('{$cust_name}','{$ara_name}','{$cust_hp}','{$cust_num}','{$cust_city}','{$phone}','{$mobile}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    public function insertSale($sale_id,$sale_name,$product_id,$product_name,$priceVal,$pricePercent,$secondary_item_id,$item_min_quant,$item_add_quant,$date_exp){

        include'conn_db.php';

        $query = "INSERT INTO `sals`(`sale_id`, `sale_name`, `product_id`, `product_name`, `priceVal`, `pricePercent`, `secondary_item_id`, `item_min_quant`, `item_add_quant`, `date_exp`) VALUES ('{$sale_id}','{$sale_name}','{$product_id}','{$product_name}','{$priceVal}','{$pricePercent}','{$secondary_item_id}','{$item_min_quant}','{$item_add_quant}','{$date_exp}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

        public function insertSaleMain($name,$expired_date){

        include'conn_db.php';

        $query = "INSERT INTO `sales`( `name`,`expired_date`) VALUES ('{$name}','{$expired_date}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $conn->lastInsertId();
        }else{
            return $errMsg;
        }
    }//End

    public function insertProduct($catID,$name,$proDesc,$code,$codeIMG,$quant,$cost,$price,$endprice,$available){

        include'conn_db.php';

        $query = "INSERT INTO `products`(`cat_id`, `name`, `pro_desc`, `code`, `barcode`, `quantity`,`cost`, `price`,`end_price`, `isavailable`) VALUES ('{$catID}','{$name}','{$proDesc}','{$code}','{$codeIMG}','{$quant}','{$cost}','{$price}','{$endprice}','{$available}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    public function insertBid($bidNum,$customer,$address,$phone,$desc){

        include'conn_db.php';

        $query = "INSERT INTO `bid`(`bid_num`,`customer`,`address`,`phone`, `bid_desc`) VALUES ('{$bidNum}','{$customer}','{$address}','{$phone}','{$desc}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    public function insertCustomerHistory($custID,$history){

        include'conn_db.php';

        $query = "INSERT INTO `history`(`cust_id`, `history`) VALUES ('{$custID}','{$history}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertCategory($name,$position){

        include'conn_db.php';

        $query = "INSERT INTO `category`(`position`,`name`) VALUES ('{$position}','{$name}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    public function insertPrice($productID,$customerID,$price){

        include'conn_db.php';

        $query = "INSERT INTO `prices`(`product_id`, `customer_id`, `price`) VALUES ('{$productID}','{$customerID}','{$price}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertSetting($sett){

        include'conn_db.php';

        $query = "INSERT INTO `settings`(`sett`) VALUES ('{$sett}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertProvider($name,$logo){

        include'conn_db.php';

        $query = "INSERT INTO `settings`(`name`, `logo`) VALUES ('{$name}','{$logo}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertInventory($product_id,$product_barcode,$quantity){

        include'conn_db.php';

        $query = "INSERT INTO `stocks`(`product_id`, `product_barcode`, `quantity`) VALUES ('{$product_id}','{$product_barcode}','{$quantity}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertImage($itemID,$imagePath){

        include'conn_db.php';

        $query = "INSERT INTO `images`(`item_id`, `image_path`) VALUES ('{$itemID}','{$imagePath}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertTMP($agentID,$tmp,$customer,$ordr,$note){

        include'conn_db.php';

        $query = "INSERT INTO `tmp_orders`(`agentID`, `tmp`, `customer`, `ordr`, `note`) VALUES ('{$agentID}','{$tmp}','{$customer}','{$ordr}','{$note}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertDiversity($customer_id,$customer_name,$item_id,$item_name){

        include'conn_db.php';

        $query = "INSERT INTO `diversity`(`customer_id`, `customer_name`, `item_id`, `item_name`) VALUES ('{$customer_id}','{$customer_name}','{$item_id}','{$item_name}')";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }
        return $status;
    }//End

    public function insertCompany($comp_name,$comp_hp,$comp_phone,$comp_mobile,$comp_fax,$comp_address,$comp_logo){

        include'conn_db.php';

        $query = "INSERT INTO `company`(`comp_name`, `comp_hp`, `comp_phone`, `comp_mobile`, `comp_fax`, `comp_address`, `comp_logo`) VALUES ('{$comp_name}','{$comp_hp}','{$comp_phone}','{$comp_mobile}','{$comp_fax}','{$comp_address}','{$comp_logo}')";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    //---------------------------------------------------------------

    public function updateOrderDriver($id,$driver){

        include'conn_db.php';

        $query = "UPDATE `orders` SET `driver`='{$driver}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateOrder($id,$DescJson,$note,$total){

        include'conn_db.php';

        $query = "UPDATE `orders` SET `order_desc`='{$DescJson}', `note`='{$note}', `order_total`='{$total}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateTotalOrder($id,$total){

        include'conn_db.php';

        $query = "UPDATE `orders` SET `order_total`='{$total}' WHERE `id`='{$id}'";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

        public function updateOrderTax($id,$tax){

        include'conn_db.php';

        $query = "UPDATE `orders` SET `order_tax`='{$tax}' WHERE `id`='{$id}'";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

        public function updateEditOrder($id,$DescJson,$note){

        include'conn_db.php';

        $query = "UPDATE `orders` SET `order_desc`='{$DescJson}', `note`='{$note}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateOrderStatus($id,$status,$msg){

        include'conn_db.php';

        $query = "UPDATE `orders` SET `order_status`='{$status}', `ban_note`='{$msg}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateMCOrderStatus($id,$status,$msg){

        include'conn_db.php';

        $query = "UPDATE `mco_order` SET `order_status`='{$status}', `ban_note`='{$msg}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateRehearStatus($id,$status,$msg){

        include'conn_db.php';

        $query = "UPDATE `rehearsals` SET `re_status`='{$status}', `ban_note`='{$msg}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateCustomerWithUSR($id,$name,$ara_name,$hp,$custnum,$city,$phone,$mobile,$usrName,$usrPass){

        include'conn_db.php';

        $query = "UPDATE `customers` SET `name`='{$name}',`ara_name`='{$ara_name}',`hp`='{$hp}',`cust_num`='{$custnum}',`city`='{$city}',`phone`='{$phone}',`mobile`='{$mobile}',`usrName`='{$usrName}',`usrPass`='{$usrPass}'  WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateCustomer($id,$name,$ara_name,$hp,$custnum,$city,$phone,$mobile){

        include'conn_db.php';

        $query = "UPDATE `customers` SET `name`='{$name}',`ara_name`='{$ara_name}',`hp`='{$hp}',`cust_num`='{$custnum}',`city`='{$city}',`phone`='{$phone}',`mobile`='{$mobile}'  WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateProduct($id,$catID,$name,$proDesc,$code,$codeIMG,$quant,$cost,$price,$endprice,$available){

        include'conn_db.php';

        $query = "UPDATE `products` SET `cat_id`='{$catID}', `name`='{$name}',`pro_desc`='{$proDesc}',`code`='{$code}',`barcode`='{$codeIMG}',`quantity`='{$quant}',`cost`='{$cost}',`price`='{$price}',`end_price`='{$endprice}',`isavailable`='{$available}' WHERE `id`='{$id}'";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    public function updateProductCost($id,$cost){

        include'conn_db.php';

        $query = "UPDATE `products` SET `cost`='{$cost}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateImgUrl($imgPath,$id){

        include'conn_db.php';

        $query = "UPDATE `products` SET `img_path`='{$imgPath}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateCategory($position,$name,$id){

        include'conn_db.php';

        $query = "UPDATE `category` SET `position`='{$position}', `name`='{$name}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updatePrice($price,$id){

        include'conn_db.php';

        $query = "UPDATE `prices` SET `price`='{$price}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateSettings($sett){

        include'conn_db.php';

        $query = "UPDATE `settings` SET `sett`='{$sett}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateProvider($id,$name,$logo){

        include'conn_db.php';

        $query = "UPDATE `providers` SET `name`='{$name}',`logo`='{$logo}' WHERE `id`='{$id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateInventory($product_id,$product_barcode,$quantity){

        include'conn_db.php';

        $query = "UPDATE `stocks` SET `product_barcode`='{$product_barcode}',`quantity`='{$quantity}' WHERE `product_id`='{$product_id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateInventoryInHold($product_id,$inHold){

        include'conn_db.php';

        $query = "UPDATE `stocks` SET `inHold`='{$inHold}' WHERE `product_id`='{$product_id}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateTMP($tmp,$ordr,$note){

        include'conn_db.php';

        $query = "UPDATE `tmp_orders` SET `ordr`='{$ordr}',`note`='{$note}' WHERE `tmp`='{$tmp}'";
        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;
    }//End

    public function updateCompany($id,$comp_name,$comp_hp,$comp_phone,$comp_mobile,$comp_fax,$comp_address,$comp_logo){

        include'conn_db.php';

        $query = "UPDATE `company` SET `comp_name`='{$comp_name}',`comp_hp`='{$comp_hp}',`comp_phone`='{$comp_phone}',`comp_mobile`='{$comp_mobile}',`comp_fax`='{$comp_fax}',`comp_address`='{$comp_address}',`comp_logo`='{$comp_logo}' WHERE `id`='{$id}'";
        $conn->setAttribute( PDO::ATTR_ERRMODE, PDO::ERRMODE_WARNING );
        $stmt = $conn->prepare($query);
        $stmt->execute();
        $errMsg = $stmt->errorInfo();
        if($errMsg[0] == 00000){
            $status = "success";
            return $status;
        }else{
            return $errMsg;
        }
    }//End

    //---------------------------------------------------------------

    public function DeleteTMP($tmp){

        include'conn_db.php';

        $query = "DELETE FROM `tmp_orders` WHERE `tmp`='{$tmp}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteOrder($id){

        include'conn_db.php';

        $query = "UPDATE `orders` SET `deleted` = '1' WHERE `orders`.`id` ='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteMCOrder($id){

        include'conn_db.php';

        $query = "UPDATE `mco_order` SET `deleted` = '1' WHERE `mco_order`.`id` ='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteRehear($id){

        include'conn_db.php';

        $query = "UPDATE `rehearsals` SET `deleted` = '1' WHERE `rehearsals`.`id` ='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteSale(){

        include'conn_db.php';

        $query = "DELETE FROM `sals` WHERE `date_exp`< CURRENT_DATE ";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteProduct($id){

        include'conn_db.php';

        $query = "DELETE FROM `products` WHERE `id`= '{$id}' ";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteCustomerHistory($id){

        include'conn_db.php';

        $query = "DELETE FROM `history` WHERE `id`='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteCategory($id){

        include'conn_db.php';

        $query = "DELETE FROM `category` WHERE `id`='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteProvider($id){

        include'conn_db.php';

        $query = "DELETE FROM `providers` WHERE `id`='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteImage($id){

        include'conn_db.php';

        $query = "DELETE FROM `images` WHERE `id`='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

         public function DeleteCustomer($id){

        include'conn_db.php';

        $query = "DELETE FROM `customers` WHERE `id` ='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    public function DeleteDiversity($id){

        include'conn_db.php';

        $query = "DELETE FROM `diversity` WHERE `customer_id` ='{$id}'";

        $stmt = $conn->prepare($query);

        if($stmt->execute()){
            $status = "success";
        }else{
            $status = "failed";
        }

        return $status;

    }//End

    //---------------------------------------------------------------

    public function getAllOrdersNum($status_num){

        include'conn_db.php';

        $query = "SELECT COUNT(*) as staticCount FROM `orders` WHERE (`order_status` = '{$status_num}' AND `deleted`='0')";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getAllReNum($status_num){

        include'conn_db.php';

        $query = "SELECT COUNT(*) as rehealCount FROM `rehearsals` WHERE `re_status` = '{$status_num}' AND `deleted`='0'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOrdersNumByitemID($itemID,$dateStart,$dateEnd){

        include'conn_db.php';

        $query = "SELECT * FROM `orders` WHERE `order_desc` LIKE '%\"product_id\":\"{$itemID}\"%' AND `created` BETWEEN '{$dateStart} 00:00:00' AND '{$dateEnd} 23:59:59' AND `deleted`='0' AND `order_status`='1'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOrdersNumByitemIDAgentID($itemID,$AgentID,$dateStart,$dateEnd){

        include'conn_db.php';

        $query = "SELECT * FROM `orders` WHERE `order_desc` LIKE '%\"product_id\":\"{$itemID}\"%' AND `created` BETWEEN '{$dateStart} 00:00:00' AND '{$dateEnd} 23:59:59' AND `agent_id` = '{$AgentID}' AND `deleted`='0' AND `order_status`='1'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOrdersNumByCustomerID($customerID,$dateStart,$dateEnd){

        include'conn_db.php';

        $query = "SELECT * FROM `orders` WHERE `customer_id` = '{$customerID}' AND `created` BETWEEN '{$dateStart} 00:00:00' AND '{$dateEnd} 23:59:59' AND `deleted`='0' AND `order_status`='1'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getOrdersNumByAgentID($agentID,$dateStart,$dateEnd){

        include'conn_db.php';

        $query = "SELECT * FROM `orders` WHERE `agent_id` = '{$agentID}' AND `created` BETWEEN '{$dateStart} 00:00:00' AND '{$dateEnd} 23:59:59' AND `deleted`='0' AND `order_status`='1'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

    public function getNumOrdersNumByAgentID($agentID,$dateStart,$dateEnd){

        include'conn_db.php';

        $query = "SELECT COUNT(*) as agentOrderNumber FROM `orders` WHERE `agent_id` = '{$agentID}' AND `created` BETWEEN '{$dateStart} 00:00:00' AND '{$dateEnd} 23:59:59' AND `deleted`='0' AND `order_status`='1'";
        $stmt = $conn->prepare($query);
        $stmt->execute();
        return $stmt;
    }//End

}//End Class