<?php
include '../core/BigData.php';
$BD = new BigData();
//-------------------------------------------

?>

<!DOCTYPE html>
<html lang="he">
<head>
<title>קטלוג מוצרים</title>
    <meta charset="utf-8">
    <!-- <link rel="shortcut icon" href="https://bd-apps.net/b-agents/ftp/logos/<?php echo $merID;?>.webp?ver=1.7" type="image/x-icon"> -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!--Favicon -->
    <!-- <link rel="icon" href="../ftp/logo.webp?ver=1.2" type="image/x-icon"/> -->
    <!--Favicon -->
    <script src="../assets/jquery/jquery-3.6.1.js"></script>
    <script src="../assets/bootstrap/js/bootstrap.js?v=1.2"></script>
    <link rel="stylesheet" href="../assets/bootstrap/css/bootstrap.min.css?ver=1.2">
    <link href="../style/fontawesome/css/all.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js"></script>
    <link href="https://fonts.googleapis.com/css?family=Rubik&display=swap" rel="stylesheet">
    <script src="../assets/lazy/lazyload.min.js"></script>
    <link rel="stylesheet" href="style.css?v=1.0">
    <script src="../assets/sweet/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="../assets/sweet/sweetalert2.min.css">

</head>
<body>
  <div class="catalog-nav">
    <img class="nav-icon-img-left" src="icons/info.webp" alt="home icon">
    <div class="nav-icon">
      <img onclick="getAllProducts()" class="nav-icon-img" src="icons/home.webp" alt="home icon">
    </div>
    <img onclick="openmodal()" class="nav-icon-img-right" src="icons/category.webp" alt="home icon">
  </div>
  <div class="catalog-body">
    <div class="catalog-card">
      <div class="catalog-card-img"></div>
      <div class="catalog-card-product-info"></div>
      <div class="catalog-card-price"></div>
    </div>
  </div>
<!-------------------------------------------------------->
<!-- The Modal -->
<div class="modal fade" id="categoryModal">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">

      <!-- Modal Header -->
      <div class="modal-header">
        <h4 class="modal-title">רשימת קטיגוריות</h4>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>

      <!-- Modal body -->
      <div class="modal-body">
        <div id="categoriesBtns" class="row">
          
        </div>
      </div>

      <!-- Modal footer -->
      <div class="modal-footer">
        <button type="button" class="btn btn-danger" data-bs-dismiss="modal">סגור</button>
      </div>

    </div>
  </div>
</div>
<!-------------------------------------------------------->
</body>
</html>

<script>
  var lazyLoad = new LazyLoad({
        // Your custom settings go here
      });
      console.log('lazyLoadInstance >> ',lazyLoad);
      lazyLoad.update();
//-----------------------------------------
  $(document).ready(()=>{
      getAllProducts();
  })
//-----------------------------------------
  function getAllProducts(){
    $.ajax({
      url:'../core/api/getAllProductsForCatalog.php',
      type:'POST',
      data:{'merID':'<?php echo $_GET['merHash'];?>'},
      beforeSend:function(){
        $('.catalog-body').html('');
      },
      success:function(res){
        var resJson = JSON.parse(res);
        console.log(resJson);
        if(resJson.length > 0){
          resJson.forEach((item)=>{
            $('.catalog-body').append('<div class="catalog-card">'+
                                        '<div class="catalog-card-img"><img class="catalog-product-img lazy" data-src="../'+item.img+'"></div>'+
                                        '<div class="catalog-card-product-info">'+
                                        '<div class="catalog-product-name">שם מוצר : '+item.name+'</div>'+
                                        '<div class="catalog-product-code">קוד : '+item.code+'</div>'+
                                        '<div class="catalog-product-quant">כמות בקרטון : '+item.quantity+' יח</div>'+
                                        '</div>'+
                                        '</div>');
          })
        }
         lazyLoad.update();
      }
    })//end ajax
  }
//-----------------------------------------
  function openmodal(){
    $.ajax({
      url:'../core/api/getAllCategories.php',
      type:'POST',
      data:{'merID':'<?php echo $_GET['merHash'];?>'},
      success:function(catRes){
        var jsonCatRes = JSON.parse(catRes);
        if(jsonCatRes.length > 0){
          var btns = '';
          jsonCatRes.forEach((cat)=>{
            btns += '<div class="col-6">'+
                        '<div class="d-grid gap-3">'+
                          '<button onclick="getItemsByCategory('+cat.id+')" type="button" class="categoryBtnsClass btn btn-secondary btn-block">'+cat.name+'</button>'+
                        '</div>'+
                      '</div>';
          })
          $('#categoriesBtns').html(btns);
        }
      },
      complete:function(){
        $('#categoryModal').modal('show');
      }
    })
    
  }
//-----------------------------------------
  function getItemsByCategory(id){
    $.ajax({
      url:'../core/api/getProductByCategory.php',
      type:'POST',
      data:{'merID':'<?php echo $_GET['merHash'];?>','catID':id},
      beforeSend:function(){
        $('.catalog-body').html('');
      },
      success:function(res){
        var resJson = JSON.parse(res);
        if(resJson.length > 0){
          resJson.forEach((item)=>{
            $('.catalog-body').append('<div class="catalog-card">'+
                                        '<div class="catalog-card-img"><img class="catalog-product-img lazy" data-src="../'+item.img+'"></div>'+
                                        '<div class="catalog-card-product-info">'+
                                        '<div class="catalog-product-name">שם מוצר : '+item.name+'</div>'+
                                        '<div class="catalog-product-code">קוד : '+item.code+'</div>'+
                                        '<div class="catalog-product-quant">כמות בקרטון : '+item.quantity+' יח</div>'+
                                        '</div>'+
                                        '</div>');

                  
          })
        }
        lazyLoad.update();
      },
      complete:function(){
        $('#categoryModal').modal('hide');
      }
    })//end ajax
  }
//-----------------------------------------

</script>
